--EXEC P_RC_VD_CONV_ANALISE_VENDAS 545,'2012-05-01'
CREATE PROCEDURE P_RC_VD_CONV_ANALISE_VENDAS (@CD_FILIAL INT,@DT_PROC AS DATETIME) AS 
DECLARE @CD_CTR INT

SET @CD_CTR =ISNULL((SELECT
						MAX(CD_CTR)
					 FROM
						RC_VD_CONV),1)
CREATE TABLE
#rsVendas
(
	CD_EMP INT, 
	CD_CTR INT IDENTITY (1, 1),
	CD_FILIAL INT, 
	CD_VD INT,
	CD_CX INT,
	NR_ECF INT,
	CD_CLI INT,
	DT_VD DATETIME,
	DT_FECHA DATETIME, 
	VLR_CONV MONEY,
	ST_FECHVD_CONV INT,
	CD_USU  INT,
	DT_CAD DATETIME,
	DT_ATUAL DATETIME,
	TP_LANC INT,
	NR_AUTORIZACAO VARCHAR(100),
	PARC INT,
	TP_CANCEL INT,
	CD_CONV INT,
	HR_VD DATETIME,
	DT_GLOSA DATETIME,
	FLAG_CONV_AFASTADO INT,
	DT_CAD_AUDIT DATETIME
)

INSERT INTO #rsVendas
(
	CD_EMP, 
	CD_FILIAL, 
	CD_VD,
	CD_CX,
	NR_ECF,
	CD_CLI,
	DT_VD,
	DT_FECHA, 
	VLR_CONV,
	ST_FECHVD_CONV,
	CD_USU,
	DT_CAD,
	DT_ATUAL,
	TP_LANC,
	NR_AUTORIZACAO,
	PARC,
	TP_CANCEL,
	CD_CONV,
	HR_VD,
	DT_GLOSA,
	FLAG_CONV_AFASTADO,
	DT_CAD_AUDIT)
SELECT     
	PDV_VD.CD_EMP, 
	PDV_VD.CD_FILIAL, 
	PDV_VD.CD_VD,
	PDV_VD.CD_CX,
	PDV_VD.NR_ECF,
	PDV_VD.CD_CLI,
	PDV_VD.DT_VD,
	PDV_VD.DT_VD, 
	PDV_VD.VLR_CONV,
	0 AS ST_FECHVD_CONV,
	PDV_VD.CD_USU,
	PDV_VD.DT_VD,
	NULL,
	0 AS TP_LANC,
	'' AS NR_AUTORIZACAO,
	1,
	0,
	RC_CLI_CONV.CD_CONV,
	PDV_VD.HR_VD,
	NULL,
	0,
	GETDATE()
FROM         
	PDV_VD INNER JOIN RC_CLI ON 
	PDV_VD.CD_EMP = RC_CLI.CD_EMP AND 
	PDV_VD.CD_CLI = RC_CLI.CD_CLI 
	INNER JOIN RC_CLI_CONV_RC_CLI ON 
	RC_CLI.CD_EMP = RC_CLI_CONV_RC_CLI.CD_EMP AND 
	RC_CLI.CD_CLI = RC_CLI_CONV_RC_CLI.CD_CLI 
	INNER JOIN RC_CLI_CONV ON 
	RC_CLI_CONV_RC_CLI.CD_EMP = RC_CLI_CONV.CD_EMP AND 
	RC_CLI_CONV_RC_CLI.CD_CONV = RC_CLI_CONV.CD_CONV 
	LEFT OUTER JOIN PDV_VD_RC_VD_CONV ON 
	PDV_VD.CD_VD = PDV_VD_RC_VD_CONV.CD_VD AND 
	PDV_VD.CD_FILIAL = PDV_VD_RC_VD_CONV.CD_FILIAL AND 
    PDV_VD.CD_EMP = PDV_VD_RC_VD_CONV.CD_EMP
WHERE     
	PDV_VD.CD_EMP = 1 
	AND PDV_VD.DT_VD >= @DT_PROC 
	AND PDV_VD.CD_FILIAL = @CD_FILIAL
	AND PDV_VD.VLR_CONV > 0 
	AND PDV_VD.ST_VD = 0
	AND PDV_VD_RC_VD_CONV.CD_EMP IS NULL
	AND RC_CLI_CONV.TP_CONV=0
ORDER BY
	PDV_VD.CD_FILIAL,
	PDV_VD.DT_VD,
	PDV_VD.NR_ECF,
	PDV_VD.CD_CX 
	
INSERT INTO RC_VD_CONV	
SELECT 
	CD_EMP, 
	@CD_CTR + CD_CTR,
	CD_FILIAL, 
	CD_CX,
	NR_ECF,
	CD_CLI,
	DT_VD,
	DT_FECHA, 
	VLR_CONV,
	ST_FECHVD_CONV,
	CD_USU,
	DT_CAD,
	DT_ATUAL,
	TP_LANC,
	NR_AUTORIZACAO,
	PARC,
	TP_CANCEL,
	CD_CONV,
	HR_VD,
	DT_GLOSA,
	FLAG_CONV_AFASTADO,
	DT_CAD_AUDIT
FROM 
	#rsVendas	
ORDER BY
	CD_CTR

INSERT INTO PDV_VD_RC_VD_CONV
SELECT     
	CD_EMP, 
	CD_FILIAL, 
	CD_VD,
	@CD_CTR + CD_CTR
FROM         
	#rsVendas	
ORDER BY
	CD_CTR
	
DROP TABLE #rsVendas	
